

if(typeof($)=='undefined')
	$={};

$._ext = {
    //Evaluate a file and catch the exception.
    evalFile : function(path) {
        try {
            $.evalFile(path);
        } catch (e) {alert("Exception:" + e);}
    },
    
    // Evaluate all the files in the given folder 
    evalFiles: function(jsxFolderPath) {
        var folder = new Folder(jsxFolderPath);
        if (folder.exists) {
            var jsxFiles = folder.getFiles("*.jsx");
            for (var i = 0; i < jsxFiles.length; i++) {
                var jsxFile = jsxFiles[i];
                $._ext.evalFile(jsxFile);
            }
        }
    },
    
    al : function() {alert('blah');},
    
    createBrightMasks : function()
    {
        var startDisplayDialogs = app.displayDialogs
        app.displayDialogs = DialogModes.NO
        createBrightsDarks("Brights");
        app.activeDocument.selection.deselect();
        defaultActiveChannels();
        app.displayDialogs = startDisplayDialogs;
    },
    
    createDarkMasks : function()
    {
        var startDisplayDialogs = app.displayDialogs
        app.displayDialogs = DialogModes.NO
        createBrightsDarks("Darks");
        app.activeDocument.selection.deselect();
        defaultActiveChannels();
        app.displayDialogs = startDisplayDialogs;
    },
    
    createMidtoneMasks : function()
    {
        createMidtoneMasksSub(false);
    },
    
    createLuminosityMasks : function()
    {
        this.createBrightMasks();
        this.createDarkMasks();
        createMidtoneMasksSub(true);
        defaultActiveChannels();
    },

	deleteBrightMasks : function()
	{
	    for(i = 1; i <= 6; i++)
	    {
	        try 
	        {
	            app.activeDocument.channels.getByName("Brights "+i).remove();
	        } catch(e)
	        {;}
	    }
	
	 }, 
	
	deleteDarkMasks : function()
	 {
	    for(i = 1; i <= 6; i++)
	    {
	         try 
	         {
	             app.activeDocument.channels.getByName("Darks "+i).remove();
	         } catch(e)
	        {;}
	    }
	},
	
	deleteMidtoneMasks : function()
	 {
	    for(i = 1; i <= 6; i++)
	    {
	         try 
	         {
	             app.activeDocument.channels.getByName("Midtones "+i).remove();
	         } catch(e)
	        {;}
	    }
	 },
	
	deleteLuminosityMasks : function()
	{
	    this.deleteBrightMasks();
	    this.deleteDarkMasks();
	    this.deleteMidtoneMasks();
	}
};


function createMidtoneMasksSub(reuse)
{
    var startDisplayDialogs = app.displayDialogs
    app.displayDialogs = DialogModes.NO
    
    if(!reuse)
    {
        createBrightsDarks ("B_temp");
        createBrightsDarks("D_temp");
    }
    var brightName = reuse ? "Brights" : "B_temp";
    var darkName = reuse ? "Darks" : "D_temp";

    for(i = 1; i <= 6; i++)
    {
        app.activeDocument.selection.selectAll();
        var brightChan = app.activeDocument.channels.getByName(brightName +" "+i);
        var darkChan = app.activeDocument.channels.getByName(darkName +" "+i);
        if(brightChan != undefined && darkChan != undefined)
        {
            app.activeDocument.selection.load(brightChan, SelectionType.DIMINISH);
            app.activeDocument.selection.load(darkChan, SelectionType.DIMINISH);
            var chan = saveSelection("Midtones", i);
            if(!reuse)
            {
                brightChan.remove();
                darkChan.remove();
            }
        }
    }
    app.activeDocument.selection.deselect();
    defaultActiveChannels();
    app.displayDialogs = startDisplayDialogs;
}


function selectRGB()
{
    cTID = function(s) { return app.charIDToTypeID(s); };
    sTID = function(s) { return app.stringIDToTypeID(s); };
    
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putProperty(cTID('Chnl'), sTID("selection"));
    desc1.putReference(cTID('null'), ref1);
    var ref2 = new ActionReference();
    ref2.putEnumerated(cTID('Chnl'), cTID('Chnl'), sTID("RGB"));
    desc1.putReference(cTID('T   '), ref2);
    executeAction(cTID('setd'), desc1, DialogModes.NO);
}

   
function saveSelection(name, index)
{
    var channelRef = app.activeDocument.channels.add();
    channelRef.kind = ChannelType.MASKEDAREA;
    channelRef.name = name + " " + index;
    try
    {
    	app.activeDocument.selection.store(channelRef, SelectionType.REPLACE)
	} catch(e) {;}
    return channelRef
}

function defaultActiveChannels()
{
    var chans = app.activeDocument.componentChannels;
    app.activeDocument.activeChannels = chans;
}

function createBrightsDarks(name)
{
    selectRGB();
    if( name == "Darks" || name == "D_temp")
        app.activeDocument.selection.invert();
    for(i = 1; i <= 6; i++)
    {
        try
        {
            var chan = saveSelection(name, i);
            app.activeDocument.selection.load(chan, SelectionType.INTERSECT)
        }
        catch (e)
        {
            ;
        }
    }
}  

